$(function () {
    $(".overlay").hide();
    $("#cari_data").on({
        keypress: function () {
            typed_into = true;
        },
        change: function () {
            var kode = $("#cari_data").val();
            var token = $("meta[name='csrf-token']").attr("content");
            if (kode == null) {
                $("#cari_data").focus();
                $("#cari_data").val("");
            } else {
                $.ajax({
                    type: "POST",
                    url: "kode-produk",
                    dataType: "JSON",
                    data: {
                        kode: kode,
                        _token: token,
                    },
                    success: function (data) {
                        if (data.hasil == "ada") {
                            $("#cari_data").val("");
                            $("#cari_data").focus();
                            $(".produk").remove();
                            keranjang(kode);
                        } else if (data.hasil == "kosong") {
                            nama_produk(kode);
                        }
                    },
                });
            }
        },
    });

    function nama_produk(nama) {
        var token = $("meta[name='csrf-token']").attr("content");
        if (nama == null || nama == " ") {
            $("#cari_data").focus();
            $("#cari_data").val("");
        } else {
            $.ajax({
                type: "post",
                url: "cari-produk",
                data: {
                    nama: nama,
                    _token: token,
                },
                success: function (data) {
                    if (data == "kosong") {
                        toastr.info("Produk tidak terdaftar .");
                        $(".produk").remove();
                        $("#cari_data").focus();
                    } else {
                        $(".produk").remove();
                        $(".show").append(
                            '<div class="produk"><ul class="list-group">' +
                                data +
                                "</ul></div>"
                        );
                    }
                },
            });
        }
    }

    $(".show").on("click", ".pilih", function () {
        var kode = $(this).attr("data-kd");
        $(".produk").remove();
        $("#cari_data").val("");
        $("#cari_data").focus();
        keranjang(kode);
    });

    function keranjang(kode) {
        var token = $("meta[name='csrf-token']").attr("content");
        $(".over1").show();
        $.ajax({
            type: "post",
            url: "simpan-keranjang",
            data: {
                kode: kode,
                _token: token,
            },
            success: function (data) {
                if (data == "habis") {
                    Swal.fire({
                        icon: "error",
                        title: "Maaf",
                        text: "Stok Habis!",
                    });
                    $(".overlay").hide();
                } else if (data == "ada") {
                    $(".overlay").hide();
                    toastr.success("Item berhasil ditambahkan.");
                    tampil_keranjang();
                    tampil_data();
                }
            },
        });
    }

    tampil_keranjang();
    function tampil_keranjang() {
        $.ajax({
            type: "GET",
            url: "tampil-keranjang",
            success: function (data) {
                $("#view").html(data);
                $(".overlay").hide();
            },
        });
    }

    tampil_data();
    function tampil_data() {
        $.ajax({
            type: "GET",
            url: "tampil-nota",
            dataType: "JSON",
            success: function (data) {
                $("#petugas").val(data.petugas);
                $("#tgl").val(data.tgl);
                $("#kode").val(data.kode);
                $("#ttl").html(data.ttl);
                $("#ttll").html(data.ttl);
                $("#ttlasl").val(data.ttlasl);
                $("#ttlasl2").val(data.ttlasl);

                $("#tgu").html(data.tgu);

                $("#poin").val(data.poin);

                $("#jumlahtotal").val(data.jumlah);
                if (data.viabayar == "K") {
                    $("#cash").prop("checked", true);
                    $("#viabayar").val("K");
                } else {
                    $("#transfer").prop("checked", true);
                    $("#viabayar").val("T");
                }

                if (data.sts_antar == "Y") {
                    $("#stsantar").prop("checked", true);
                }

                if (data.bayar != 0) {
                    $("#pelanggan").val(data.nm_member);
                    $("#pelanggan").prop("readonly", false);
                    $("#kode_member").val(data.kode_member);
                    $("#ongkir").val(data.ongkir);
                    $("#ongkirasl").val(data.ongkirasl);
                    $("#bayar").val(data.bayar);
                    $("#dbyasl").val(data.dbyasl);
                    $("#kembali").val(data.sisa);
                    $("#subtotal").val(data.sub2);
                    $("#dis").val(data.dis);
                } else {
                    $("#subtotal").val(data.sub);
                    member();
                }
            },
        });
    }
    // $(".txtedit").hide();
    $("#view").on("click", ".edit", function () {
        $(".txtedit").hide();
        $(this).next(".txtedit").show().focus();
        $(this).hide();
    });
    $("#view").on("focusout", ".txtedit", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = this.id;
        var value = $(this).val();

        $(this).hide();
        $(this).prev(".edit").show();
        $(this).prev(".edit").text(value);

        $.ajax({
            type: "POST",
            url: "edit-qty",
            data: {
                id: id,
                value: value,
                _token: token,
            },
            success: function (data) {
                if (data == "ada") {
                    toastr.success("Qty berhasil dirubah.");
                    tampil_keranjang();
                    tampil_data();
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "Maaf",
                        text: "Jumlah yang anda inputkan melebihi dari stok!",
                    });
                    tampil_keranjang();
                    tampil_data();
                }
            },
        });
    });

    $("#view").on("click", ".hapus", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");
        var nama = $(this).attr("data-nm");

        Swal.fire({
            title: "Apa anda yakin?",
            text: "Data Item  ( " + nama + " )  akan di hapus!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Ya, Hapus!",
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: "post",
                    url: "delete-keranjang",
                    data: {
                        id: id,
                        _token: token,
                    },
                    success: function (data) {
                        toastr.success("Item berhasil dihapus.");
                        tampil_keranjang();
                        tampil_data();

                        $("#cari_data").val("");
                        $("#cari_data").focus();
                    },
                });
            }
        });
    });

    $(".new").click(function () {
        var kode = $("#kode").val();
        var token = $("meta[name='csrf-token']").attr("content");
        var sts = "T";
        $.ajax({
            type: "POST",
            url: "proses-tunggu",
            dataType: "JSON",
            data: {
                kode: kode,
                sts: sts,
                _token: token,
            },
            beforeSend: function () {
                $(".new").html(
                    '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                );
                $(".new").attr("disabled", true);
            },
            success: function (data) {
                $(".new").html("New");
                $(".new").attr("disabled", false);
                toastr.success("Silahkan mulai transaksi baru");
                tampil_keranjang();
                tampil_data();
                member();
                $("#cari_data").val("");
                $("#cari_data").focus();
            },
        });
    });

    $(".open").click(function () {
        $(".datahead").html("Data Transaksi");
        $("#cari").hide();
        $.ajax({
            type: "GET",
            url: "open-keranjang",
            // dataType: "JSON",
            success: function (data) {
                $("#dttransaksi").modal("show");
                $("#vopen").remove();
                $(".dtopen").append(`<div id="vopen">` + data + `</div>`);
                member();
            },
        });
    });

    $("#dttransaksi").on("click", ".pilih_open", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var kode = $(this).attr("data-kd");
        var sts = "Y";
        $(".overlay").show();
        $.ajax({
            type: "POST",
            url: "proses-tunggu",
            dataType: "JSON",
            data: {
                kode: kode,
                sts: sts,
                _token: token,
            },
            success: function (data) {
                $("#dttransaksi").modal("hide");
                toastr.success("Transaksi dibuka kembali.");
                tampil_keranjang();
                tampil_data();
                $("#cari_data").val("");
                $("#cari_data").focus();
            },
        });
    });

    $(".cari_member").click(function () {
        $("#pelanggan").prop("readonly", false);
        $("#pelanggan").val("");
        $("#pelanggan").focus();
    });

    $("#pelanggan").on({
        keypress: function () {
            typed_into = true;
        },
        change: function () {
            var kode = $("#pelanggan").val();
            var token = $("meta[name='csrf-token']").attr("content");
            if (kode == null) {
                $("#pelanggan").focus();
                $("#pelanggan").val("");
            } else {
                $.ajax({
                    type: "POST",
                    url: "kode-member",
                    dataType: "JSON",
                    data: {
                        kode: kode,
                        _token: token,
                    },
                    success: function (data) {
                        if (data.hasil == "ada") {
                            $("#pelanggan").val(data.nm);
                            $("#pelanggan").focus();
                            $(".member").remove();

                            $("#kode_member").val(data.kd);
                            $("#alamat").val(data.alamat);
                        } else if (data.hasil == "kosong") {
                            nama_member(kode);
                        }
                    },
                });
            }
        },
    });

    function nama_member(nama) {
        var token = $("meta[name='csrf-token']").attr("content");
        if (nama == null) {
            $("#pelanggan").focus();
            $("#pelanggan").val("");
        } else {
            $.ajax({
                type: "post",
                url: "cari-member",
                data: {
                    nama: nama,
                    _token: token,
                },
                success: function (data) {
                    if (data == "kosong") {
                        toastr.info("Member tidak terdaftar .");
                        $(".member").remove();
                        $("#pelanggan").focus();
                    } else {
                        $(".member").remove();
                        $(".show_member").append(
                            '<div class="member"><ul class="list-group">' +
                                data +
                                "</ul></div>"
                        );
                    }
                },
            });
        }
    }

    $(".show_member").on("click", ".pilih", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var kode = $(this).attr("data-kd");
        $.ajax({
            type: "POST",
            url: "kode-member",
            dataType: "JSON",
            data: {
                kode: kode,
                _token: token,
            },
            success: function (data) {
                $("#pelanggan").val(data.nm);
                $("#pelanggan").focus();
                $(".member").remove();

                $("#kode_member").val(data.kd);
                $("#alamat").val(data.alamat);
            },
        });
    });

    function member() {
        $("#pelanggan").val("Pelanggan");
        $(".member").remove();

        $("#kode_member").val("0");
        $("#alamat").val("-");
        $("#pelanggan").prop("readonly", true);

        $("#stsantar").prop("checked", false);
        $("#antaran").val("N");
        $("#ongkir").val(0);
        $("#ongkirasl").val(0);
        $("#bayar").val("");
        $("#brt").val("");
    }

    $("#stsantar").click(function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var kode = $("#kode_member").val();
        var ttlasl = $("#ttlasl").val();
        var ttlasl2 = $("#ttlasl2").val();
        $(".overlay").show();
        if ($(this).prop("checked")) {
            if (kode == 0 || ttlasl == 0) {
                $(this).prop("checked", false);
                if (ttlasl == 0) {
                    Swal.fire({
                        icon: "error",
                        title: "Maaf",
                        text: "Silahkan input belanjaan terlebih dahulu!",
                    });
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "Maaf",
                        text: "Silahkan pilih member  dulu!",
                    });
                }
                $(".overlay").hide();
            } else {
                $(this).prop("checked", true);
                $("#antaran").val("Y");
                $.ajax({
                    type: "POST",
                    url: "kode-member",
                    dataType: "JSON",
                    data: {
                        kode: kode,
                        _token: token,
                    },
                    success: function (data) {
                        var rupiah = (data.ongkir / 1000).toFixed(3);
                        $("#ongkir").val(rupiah);
                        $("#ongkirasl").val(data.ongkir);
                        $("#brt").val(data.brt);

                        var ttl = parseInt(ttlasl) + parseInt(data.ongkir);
                        var rupiah2 = (ttl / 1000).toFixed(3);
                        $("#subtotal").val("Rp. " + rupiah2);
                        $("#ttlasl").val(ttl);
                        $("#bayar").val("");
                        bayar();
                        $(".overlay").hide();
                    },
                });
            }
        } else {
            $(".overlay").hide();
            $(this).prop("checked", false);
            $("#antaran").val("N");
            $("#ongkir").val(0);
            $("#ongkirasl").val(0);

            var total = parseInt(ttlasl2);

            var rupiah3 = (total / 1000).toFixed(3);
            $("#subtotal").val("Rp. " + rupiah3);
            $("#ttlasl").val(total);
            $("#bayar").val("");
            bayar();
        }
    });

    $("#transfer").click(function () {
        $("#viabayar").val("T");
        var ttl = $("#ttlasl").val();
        var rupiah = (ttl / 1000).toFixed(3);
        $("#bayar").val(rupiah);
        bayar();
    });

    $("#cash").click(function () {
        $("#viabayar").val("K");
        $("#bayar").val("");
        bayar();
    });

    $("#bayar").keyup(function () {
        bayar();
    });

    function bayar() {
        var ttl = $("#ttlasl").val();
        var hrg = ".";
        var h = $("#bayar").val();
        var h = h.replaceAll(hrg, "");
        $("#dbyasl").val(h);

        var kembali = parseInt(h) - parseInt(ttl);
        var rupiah = (kembali / 1000).toFixed(3);
        if (h == "") {
            $("#kembali").val("Rp. 0");
        } else {
            $("#kembali").val("Rp. " + rupiah);
        }
    }

    $(".simpan").click(function () {
        var isi = "simpan";
        var tombol = ".simpan";
        simpan(isi, tombol);
    });
    $(".cetak").click(function () {
        var isi = "cetak";
        var tombol = ".cetak";
        simpan(isi, tombol);
    });

    function simpan(isi, tombol) {
        var token = $("meta[name='csrf-token']").attr("content");
        var kode = $("#kode").val();
        var jumlahtotal = $("#jumlahtotal").val();
        var ttl = $("#ttlasl").val();
        var dby = $("#dbyasl").val();
        var viabayar = $("#viabayar").val();
        var diskon = $("#diskon").val();

        var kode_member = $("#kode_member").val();
        var bayar = $("#bayar").val();
        var kembali = $("#kembali").val();

        var sts_antar = $("#antaran").val();
        var ongkir = $("#ongkirasl").val();

        var poin = $("#poin").val();

        if (kode == "0") {
            toastr.error("Silahkan input belanjaan terlebih dahulu.");
        } else if (bayar == "") {
            toastr.error("Silahkan input jml pembayaran terlebih dahulu.");
            $("#bayar").focus();
        } else if (parseInt(dby) < parseInt(ttl)) {
            toastr.error(
                "Pembayaran tidak boleh lebih kecil dari total denda."
            );
            $("#bayar").focus();
        } else {
            var cekk = isi;
            $.ajax({
                type: "POST",
                url: "simpan-transaksi",
                data: {
                    kode: kode,
                    diskon: diskon,
                    ttl: ttl,
                    jumlahtotal: jumlahtotal,
                    dby: dby,
                    viabayar: viabayar,
                    kode_member: kode_member,
                    sts_antar: sts_antar,
                    ongkir: ongkir,
                    poin: poin,
                    _token: token,
                },
                beforeSend: function () {
                    $(tombol).html(
                        '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                    );
                    $(tombol).attr("disabled", true);
                },
                success: function (data) {
                    if (cekk == "simpan") {
                        tampil_keranjang();
                        tampil_data();
                        Swal.fire({
                            icon: "success",
                            title: "Kembali : " + kembali,
                            text: "Pembayaran berhasil disimpan!",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                document.location.href = "";
                            }
                        });
                    } else if (cekk == "cetak") {
                        tampil_keranjang();
                        tampil_data();
                        var cekprint = $("#ckprint").val();
                        var isi = "print_simpan";
                        if (cekprint == "N") {
                            dataprint(kode);
                        } else {
                            dataprint2(kode, isi);
                        }
                    }
                },
            });
        }
    }

    $(".item").click(function () {
        $(".datahead").html("Data Produk");
        $("#cari").show();
        $.ajax({
            type: "GET",
            url: "cek-harga",
            success: function (data) {
                $("#vopen").remove();
                $(".dtopen").append(`<div id="vopen">` + data + `</div>`);
            },
        });
    });

    $(".refund").click(function () {
        $("#cari").show();
        $(".datahead").html("Data Transaksi");
        $.ajax({
            type: "GET",
            url: "refund",
            success: function (data) {
                $("#vopen").remove();
                $(".dtopen").append(`<div id="vopen">` + data + `</div>`);
            },
        });
    });

    $("#dttransaksi").on("keyup", "#cari", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var cari = $(this).val();
        var caridata = $("#caridata").val();
        $.ajax({
            type: "post",
            url: "cari-transaksi",
            data: {
                cari: cari,
                caridata: caridata,
                _token: token,
            },
            success: function (data) {
                $("#vopen").remove();
                $(".dtopen").append(`<div id="vopen">` + data + `</div>`);
            },
        });
    });

    $("#dttransaksi").on("click", ".print", function () {
        var kode = $(this).attr("data-kd");
        var cekprint = $("#ckprint").val();
        var isi = "print_ulang";
        $(this).html('<i class="fas fa-spinner fa-spin"></i> ');
        $(this).attr("disabled", true);
        if (cekprint == "N") {
            dataprint(kode);
        } else {
            dataprint2(kode, isi);
        }
    });

    $("#dttransaksi").on("click", ".print_label", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var kode = $(this).attr("data-kd");
        var cekprint = $("#ckprint").val();
        $(this).html('<i class="fas fa-spinner fa-spin"></i> Loading');
        $(this).attr("disabled", true);

        if (cekprint == "N") {
            $.ajax({
                type: "POST",
                url: "print-label",
                data: {
                    kode: kode,
                    cekprint: cekprint,
                    _token: token,
                },
                success: function (data) {
                    $(".tampil_data").html(data);
                    $("#hidedata").hide();

                    let timerInterval;
                    Swal.fire({
                        title: "Mohon tunggu sebentar!",
                        html: "Proses mempersiapkan data <b></b> milliseconds.",
                        timer: 2000,
                        timerProgressBar: true,
                        didOpen: () => {
                            Swal.showLoading();
                            const timer = Swal.getPopup().querySelector("b");
                            timerInterval = setInterval(() => {
                                timer.textContent = `${Swal.getTimerLeft()}`;
                            }, 100);
                        },
                        willClose: () => {
                            clearInterval(timerInterval);
                        },
                    }).then((result) => {
                        /* Read more about handling dismissals below */
                        if (result.dismiss === Swal.DismissReason.timer) {
                            // $('#hidedata').hide();
                            $("#hidedata").hide();
                            printPageArea("print");
                            document.location.href = "";
                        }
                    });
                },
            });
        } else {
            $.ajax({
                type: "POST",
                url: "print-label",
                data: {
                    kode: kode,
                    cekprint: cekprint,
                    _token: token,
                },
                success: function (data) {
                    Swal.fire({
                        icon: "success",
                        title: "Berhasil  ",
                        text: "Label berahasil di cetak!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "";
                        }
                    });
                },
            });
        }
    });

    function dataprint(kode) {
        var token = $("meta[name='csrf-token']").attr("content");
        $.ajax({
            type: "POST",
            url: "cetak-struk",
            // dataType: "GET",
            data: {
                kode: kode,
                _token: token,
            },
            success: function (data) {
                $(".tampil_data").html(data);
                $("#hidedata").hide();

                let timerInterval;
                Swal.fire({
                    title: "Mohon tunggu sebentar!",
                    html: "Proses mempersiapkan data <b></b> milliseconds.",
                    timer: 2000,
                    timerProgressBar: true,
                    didOpen: () => {
                        Swal.showLoading();
                        const timer = Swal.getPopup().querySelector("b");
                        timerInterval = setInterval(() => {
                            timer.textContent = `${Swal.getTimerLeft()}`;
                        }, 100);
                    },
                    willClose: () => {
                        clearInterval(timerInterval);
                    },
                }).then((result) => {
                    /* Read more about handling dismissals below */
                    if (result.dismiss === Swal.DismissReason.timer) {
                        // $('#hidedata').hide();
                        $("#hidedata").hide();
                        printPageArea("print");
                        document.location.href = "";
                    }
                });
            },
        });
    }

    function dataprint2(kode, isi) {
        var token = $("meta[name='csrf-token']").attr("content");
        $.ajax({
            type: "POST",
            url: "cetak-struk2",
            // dataType: "GET",
            data: {
                kode: kode,
                _token: token,
            },
            success: function (data) {
                if (isi == "print_ulang") {
                    Swal.fire({
                        icon: "success",
                        title: "Berhasil",
                        text: "Transaksi berhasil dicetak kembali!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "";
                        }
                    });
                } else if (isi == "print_simpan") {
                    Swal.fire({
                        icon: "success",
                        title: "Terimakasih",
                        text: "Pembayaran berhasil disimpan!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "";
                        }
                    });
                }
            },
        });
    }

    $("#viewpenjualan").on("click", ".detail", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");
        $.ajax({
            type: "POST",
            url: "detail-penjualan",
            data: {
                id: id,
                _token: token,
            },
            success: function (data) {
                $("#detail").modal("show");
                $("#vdetail").html(data);
            },
        });
    });

    $("#mkurir").on("click", ".update_pengiriman", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $("#kid").val();
        var karyawan = $("#karyawan").val();
        if (karyawan == "") {
            toastr.error("Silhkan pilih kurir terlebih dahulu.");
            $("#karyawan").focus();
        } else {
            $.ajax({
                type: "post",
                url: "update-kurir",
                data: {
                    id: id,
                    karyawan: karyawan,
                    _token: token,
                },
                beforeSend: function () {
                    $(this).html(
                        '<i class="fas fa-spinner fa-spin"></i> Proses..'
                    );
                    $(this).attr("disabled", true);
                },
                success: function (data) {
                    Swal.fire({
                        icon: "success",
                        title: "Berhasil",
                        text: "Pengiriman barang berhasil disimpan!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "";
                        }
                    });
                },
            });
        }
    });

    $("#dttransaksi").on("click", ".kurir", function () {
        var id = $(this).attr("data-id");
        var nm = $(this).attr("data-nm");
        var kd = $(this).attr("data-kd");
        var ok = $(this).attr("data-ok");
        $("#mkurir").modal("show");
        $("#kid").val(id);
        $("#knm").val(nm);
        $("#knp").val(kd);
        $("#alamtk").val(ok);
    });

    // ceklis
    $("#cekall").change(function () {
        if ($(this).prop("checked")) {
            $(".ceklis").prop("checked", true);
        } else {
            $(".ceklis").prop("checked", false);
        }
    });

    $("#pilih_hapus").click(function () {
        var allVals = [];
        $(".ceklis:checked").each(function () {
            allVals.push($(this).val());
        });
        var token = $("meta[name='csrf-token']").attr("content");

        if (allVals.length <= 0) {
            Toast.fire({
                icon: "error",
                title: "Ceklis data yang akan dihapus!!!.",
            });
        } else {
            Swal.fire({
                title: "Pastikan dengan benar!",
                text: "Data yang anda pilih akan dihapus!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Ya, Hapus!",
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "deleteall-penjualan",
                        data: {
                            allVals: allVals,
                            _token: token,
                        },
                        beforeSend: function () {
                            $("#pilih_hapus").html(
                                '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                            );
                            $("#pilih_hapus").attr("disabled", true);
                        },
                        success: function (data) {
                            // alert(data)
                            $("#pilih_hapus").html(
                                '<i class="fa fa-trash"></i>'
                            );
                            $("#pilih_hapus").attr("disabled", true);
                            Swal.fire({
                                icon: "success",
                                title: "Berhasil",
                                text: "Data berhasil dihapus!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    document.location.href = "";
                                }
                            });
                        },
                    });
                }
            });
        }
    });

    function printPageArea(areaID) {
        var printContent = document.getElementById(areaID).innerHTML;
        var originalContent = document.body.innerHTML;
        document.body.innerHTML = printContent;
        window.print();
        document.body.innerHTML = originalContent;
    }
});
